<!-- HEADER MOBILE-->
<header class="header-mobile d-block d-lg-none">
    <div class="header-mobile__bar">
        <div class="container-fluid">
            <div class="header-mobile-inner">
                <a class="logo" href="index.html">
                    {{-- <img src="images/icon/logo.png" alt="CoolAdmin" /> --}}
                    Mini Opex
                </a>
                <button class="hamburger hamburger--slider" type="button">
                    <span class="hamburger-box">
                        <span class="hamburger-inner"></span>
                    </span>
                </button>
            </div>
        </div>
    </div>
    <nav class="navbar-mobile">
        <div class="container-fluid">
            <ul class="navbar-mobile__list list-unstyled">
                @can('dashboard')
                    <li class="{{ Request::segment(1)=='dashboard' ? 'active' : '' }}">
                        <a href="{{ route('dashboard') }}">
                            <i class="fas fa-tachometer-alt"></i>Dashboard</a>
                    </li>
                @endcan
                @can('purchase-order')
                    <li class="has-sub {{ Request::segment(1)=='order' ? 'active' : '' }}">
                        <a class="js-arrow" href="#">
                            <i class="fas fa-cart-plus"></i>Purchase Order</a>
                            <ul class="navbar-mobile-sub__list list-unstyled js-sub-list">
                                @can('supplier-list')
                                    <li>
                                        <a href="{{ route('order.show') }}">Process Supplier</a>
                                    </li>
                                @endcan
                                @can('retrieve-orders')
                                    <li>
                                        <a href="{{ route('supplier.retrive') }}">Pending Orders</a>
                                    </li>
                                @endcan
                                @can('receiving-qty')
                                    <li>
                                        <a href="{{ route('supplier.receiving.add') }}">Dropin Warehouse</a>
                                    </li>
                                @endcan
                                @can('gatepass-list')
                                    <li>
                                        <a href="{{ route('gatepass.index') }}"> Gate Pass</a>
                                    </li>
                                @endcan
                                @can('supplier-statistics')
                                    <li>
                                        <a href="{{ route('order.statistics') }}">Supplier Statistics</a>
                                    </li>
                                @endcan
                            </ul>
                    </li>
                @endcan
                @can('sku-list')
                    <li class="has-sub {{ Request::segment(1)=='sku' ? 'active' : '' }}">
                        <a class="js-arrow" href="#">
                            <i class="fas fa-barcode"></i>Sku</a>
                            <ul class="navbar-mobile-sub__list list-unstyled js-sub-list">
                                @can('sku-list')
                                    <li>
                                        <a href="{{ route('show') }}">SKU List</a>
                                    </li>
                                @endcan

                                @can('type-list')
                                    <li>
                                        <a href="{{ route('supplier.articles') }}">Article List</a>
                                    </li>
                                @endcan
                                @can('color-list')
                                    <li>
                                        <a href="{{ route('supplier.colors') }}">Color List</a>
                                    </li>
                                @endcan
                                
                            </ul>
                    </li>
                @endcan
                
                {{-- @can('supplier-list') --}}
                    <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
                        <a class="js-arrow" href="#">
                            <i class="fas fa-user-plus"></i>Supplier</a>
                            <ul class="navbar-mobile-sub__list list-unstyled js-sub-list">
                                @can('supplier-list')
                                    <li>
                                        <a href="{{ route('supplier.show') }}">Supplier List</a>
                                    </li>
                                @endcan
                                @auth('supplier')
                                <li>
                                    <a href="{{ route('supplier.quantity') }}">Orders</a>
                                </li>
                                @endauth
                                
                            </ul>
                    </li>
                    @can('role-list')
                        <li class="{{ Request::segment(1)=='roles' ? 'active' : '' }}">
                            <a href="{{ route('roles.index') }}">
                                <i class="fas fa-user-secret"></i>Users</a>
                        </li>
                    @endcan
                {{-- @endcan --}}
                
                
            </ul>
        </div>
    </nav>
</header>
<!-- END HEADER MOBILE-->

<!-- MENU SIDEBAR-->
<aside class="menu-sidebar d-none d-lg-block">
    <div class="logo">
        <a href="#">
            {{-- <img src="images/icon/logo.png" alt="Cool Admin" /> --}}
            Mini Opex
        </a>
    </div>
    <div class="menu-sidebar__content js-scrollbar1">
        <nav class="navbar-sidebar">
            <ul class="list-unstyled navbar__list">
                @can('dashboard')
                    <li class="{{ Request::segment(1)=='dashboard' ? 'active' : '' }}">
                        <a href="{{ route('dashboard') }}">
                            <i class="fas fa-tachometer-alt"></i>Dashboard</a>
                    </li>
                @endcan
                @can('purchase-order')
                    <li class="has-sub {{ Request::segment(1)=='order' ? 'active' : '' }}">
                        <a class="js-arrow" href="#">
                            <i class="fas fa-cart-plus"></i>Purchase Order</a>
                            <ul class="list-unstyled navbar__sub-list js-sub-list">
                                @can('supplier-list')
                                    <li>
                                        <a href="{{ route('order.show') }}">Process Supplier</a>
                                    </li>
                                @endcan
                                @can('retrieve-orders')
                                    <li>
                                        <a href="{{ route('supplier.retrive') }}">Pending Orders</a>
                                    </li>
                                @endcan
                                @can('receiving-qty')
                                    <li>
                                        <a href="{{ route('supplier.receiving.add') }}">Dropin Warehouse</a>
                                    </li>
                                @endcan
                                @can('gatepass-list')
                                    <li>
                                        <a href="{{ route('gatepass.index') }}"> Gate Pass</a>
                                    </li>
                                @endcan
                                @can('supplier-statistics')
                                    <li>
                                        <a href="{{ route('order.statistics') }}">Supplier Statistics</a>
                                    </li>
                                @endcan
                            </ul>
                    </li>
                @endcan
                @can('sku-list')
                    <li class="has-sub {{ Request::segment(1)=='sku' ? 'active' : '' }}">
                        <a class="js-arrow" href="#">
                            <i class="fas fa-barcode"></i>SKU</a>
                            <ul class="list-unstyled navbar__sub-list js-sub-list">
                                @can('sku-list')
                                    <li>
                                        <a href="{{ route('show') }}">SKU List</a>
                                    </li>
                                @endcan

                                @can('type-list')
                                    <li>
                                        <a href="{{ route('supplier.articles') }}">Article List</a>
                                    </li>
                                @endcan
                                @can('color-list')
                                    <li>
                                        <a href="{{ route('supplier.colors') }}">Color List</a>
                                    </li>
                                @endcan
                            </ul>
                    </li>
                @endcan
                <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
                    <a class="js-arrow" href="#">
                        <i class="fas fa-user-plus"></i>Supplier</a>
                        <ul class="list-unstyled navbar__sub-list js-sub-list">
                            @can('supplier-list')
                                <li>
                                    <a href="{{ route('supplier.show') }}">Supplier List</a>
                                </li>
                            @endcan
                            
                            @auth('supplier')
                                <li>
                                    <a href="{{ route('supplier.quantity') }}">Orders</a>
                                </li>
                            @endauth
                            
                            
                        </ul>
                </li>
                @can('role-list')
                <li class="has-sub {{ Request::segment(1)=='roles' ? 'active' : '' }} {{ Request::segment(1)=='users' ? 'active' : '' }}">
                    <a class="js-arrow" href="#">
                        <i class="fas fa-user-secret"></i>Users</a>
                        <ul class="list-unstyled navbar__sub-list js-sub-list">
                            @can('supplier-list')
                                <li>
                                    <a href="{{ route('roles.index') }}">Roles</a>
                                </li>
                                <li>
                                    <a href="{{ route('users') }}">Users List</a>
                                </li>
                            @endcan
                        </ul>
                </li> 
                @endcan
            </ul>
        </nav>
    </div>
</aside>
<!-- END MENU SIDEBAR-->